/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemExchangeRod
extends Item
implements IWireframeCoordinateListProvider {
    private static final int RANGE = 3;
    private static final int COST = 40;
    private static final String TAG_REPLACEMENT_ITEM = "placedItem";
    private static final String TAG_TARGET_BLOCK_NAME = "targetBlock";
    private static final String TAG_SWAPPING = "swapping";
    private static final String TAG_SELECT_X = "selectX";
    private static final String TAG_SELECT_Y = "selectY";
    private static final String TAG_SELECT_Z = "selectZ";
    private static final String TAG_EXTRA_RANGE = "extraRange";
    private static final String TAG_SWAP_HIT_VEC = "swapHitVec";
    private static final String TAG_SWAP_DIRECTION = "swapDirection";
    private static final String TAG_SWAP_CLICKED_AXIS = "swapClickAxis";
    private static final String TAG_TEMPERANCE_STONE = "temperanceStone";

    public ItemExchangeRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Item replacement;
        List<BlockPos> swap;
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        BlockState wstate = world.m_8055_(pos);
        Block block = wstate.m_60734_();
        if (player != null && player.m_6144_()) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile == null && block.m_5456_() != Items.f_41852_ && BlockPlatform.isValidBlock(wstate, world, pos) && (wstate.m_60815_() || block instanceof AbstractGlassBlock || block instanceof IronBarsBlock) && block.m_5456_() instanceof BlockItem) {
                this.setItemToPlace(stack, block.m_5456_());
                this.setSwapTemplateDirection(stack, ctx.m_43719_());
                this.setHitPos(stack, ctx.m_43720_());
                this.displayRemainderCounter(player, stack);
                return InteractionResult.SUCCESS;
            }
        } else if (this.canExchange(stack) && !ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false) && (swap = this.getTargetPositions(world, stack, replacement = this.getItemToPlace(stack), pos, block, ctx.m_43719_())).size() > 0) {
            ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, true);
            ItemNBTHelper.setInt(stack, TAG_SELECT_X, pos.m_123341_());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Y, pos.m_123342_());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Z, pos.m_123343_());
            this.setSwapClickDirection(stack, ctx.m_43719_());
            this.setTarget(stack, block);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public InteractionResult onLeftClick(Player player, Level world, InteractionHand hand, BlockPos pos, Direction side) {
        if (player.m_5833_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_150930_((Item)this)) {
            int exchange;
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.canExchange(stack) && ManaItemHandler.instance().requestManaExactForTool(stack, player, 40, false) && (exchange = this.exchange(world, player, pos, stack, this.getItemToPlace(stack))) > 0) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, exchange, true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean equipped) {
        boolean temperanceActive;
        int extraRangeNew;
        if (!this.canExchange(stack) || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int extraRange = ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1);
        int n = extraRangeNew = ManaItemHandler.instance().hasProficiency(player, stack) ? 3 : 1;
        if (extraRange != extraRangeNew) {
            ItemNBTHelper.setInt(stack, TAG_EXTRA_RANGE, extraRangeNew);
        }
        if ((temperanceActive = ItemTemperanceStone.hasTemperanceActive(player)) != stack.m_41784_().m_128471_(TAG_TEMPERANCE_STONE)) {
            stack.m_41784_().m_128379_(TAG_TEMPERANCE_STONE, temperanceActive);
        }
        Item replacement = this.getItemToPlace(stack);
        if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
            Block target;
            int z;
            int y;
            if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, 40, false)) {
                ItemExchangeRod.endSwapping(stack);
                return;
            }
            int x = ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0);
            List<BlockPos> swap = this.getTargetPositions(world, stack, replacement, new BlockPos(x, y = ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), z = ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0)), target = ItemExchangeRod.getTargetState(stack), this.getSwapClickDirection(stack));
            if (swap.size() == 0) {
                ItemExchangeRod.endSwapping(stack);
                return;
            }
            BlockPos coords = swap.get(world.f_46441_.nextInt(swap.size()));
            int exchange = this.exchange(world, player, coords, stack, replacement);
            if (exchange > 0) {
                ManaItemHandler.instance().requestManaForTool(stack, player, exchange, true);
            } else {
                ItemExchangeRod.endSwapping(stack);
            }
        }
    }

    public List<BlockPos> getTargetPositions(Level world, ItemStack stack, Item toPlace, BlockPos pos, Block toReplace, Direction clickedSide) {
        ArrayList<BlockPos> coordsList = new ArrayList<BlockPos>();
        Direction.Axis axis = clickedSide.m_122434_();
        int xRange = this.getRange(stack, axis, Direction.Axis.X);
        int yRange = this.getRange(stack, axis, Direction.Axis.Y);
        int zRange = this.getRange(stack, axis, Direction.Axis.Z);
        for (int offsetX = -xRange; offsetX <= xRange; ++offsetX) {
            for (int offsetY = -yRange; offsetY <= yRange; ++offsetY) {
                block2: for (int offsetZ = -zRange; offsetZ <= zRange; ++offsetZ) {
                    BlockPos pos_ = pos.m_142082_(offsetX, offsetY, offsetZ);
                    BlockState currentState = world.m_8055_(pos_);
                    if (!currentState.m_60713_(toReplace) || currentState.m_60734_().m_5456_() == toPlace) continue;
                    for (Direction dir : Direction.values()) {
                        BlockPos adjPos = pos_.m_142300_(dir);
                        BlockState adjState = world.m_8055_(adjPos);
                        if (Block.m_49918_((VoxelShape)adjState.m_60816_((BlockGetter)world, pos), (Direction)dir.m_122424_())) continue;
                        coordsList.add(pos_);
                        continue block2;
                    }
                }
            }
        }
        return coordsList;
    }

    public int exchange(Level world, Player player, BlockPos pos, ItemStack rod, Item replacement) {
        BlockState stateAt;
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null) {
            return 0;
        }
        ItemStack placeStack = ItemExchangeRod.removeFromInventory(player, rod, replacement, false);
        if (!placeStack.m_41619_() && !(stateAt = world.m_8055_(pos)).m_60795_() && stateAt.m_60625_(player, (BlockGetter)world, pos) > 0.0f && stateAt.m_60734_().m_5456_() != replacement) {
            float hardness = stateAt.m_60800_((BlockGetter)world, pos);
            if (!world.f_46443_) {
                world.m_46961_(pos, !player.m_150110_().f_35937_);
                BlockHitResult hit = new BlockHitResult(this.getHitPos(rod, pos), this.getSwapTemplateDirection(rod), pos, false);
                InteractionResult result = PlayerHelper.substituteUse(new UseOnContext(player, InteractionHand.MAIN_HAND, hit), placeStack);
                if (!player.m_150110_().f_35937_) {
                    if (result.m_19077_()) {
                        ItemExchangeRod.removeFromInventory(player, rod, replacement, true);
                        this.displayRemainderCounter(player, rod);
                    } else {
                        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 2, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            }
            return hardness <= 10.0f ? 40 : (int)(20.0 + (double)(3.0f * hardness));
        }
        return 0;
    }

    public boolean canExchange(ItemStack stack) {
        return this.getItemToPlace(stack) != Items.f_41852_;
    }

    public static ItemStack removeFromInventory(Player player, Container inv, ItemStack tool, Item requested, boolean doit) {
        ArrayList<IBlockProvider> providers = new ArrayList<IBlockProvider>();
        for (int i = inv.m_6643_() - 1; i >= 0; --i) {
            ItemStack invStack = inv.m_8020_(i);
            if (invStack.m_41619_()) continue;
            Item item = invStack.m_41720_();
            if (item == requested) {
                ItemStack ret;
                if (doit) {
                    ret = inv.m_7407_(i, 1);
                } else {
                    ret = invStack.m_41777_();
                    ret.m_41764_(1);
                }
                return ret;
            }
            IBlockProvider provider = IXplatAbstractions.INSTANCE.findBlockProvider(invStack);
            if (provider == null) continue;
            providers.add(provider);
        }
        if (requested instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)requested;
            Block block = blockItem.m_40614_();
            for (IBlockProvider prov : providers) {
                if (!prov.provideBlock(player, tool, block, doit)) continue;
                return new ItemStack((ItemLike)requested);
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeFromInventory(Player player, ItemStack tool, Item item, boolean doit) {
        if (player.m_150110_().f_35937_) {
            return new ItemStack((ItemLike)item);
        }
        ItemStack outStack = ItemExchangeRod.removeFromInventory(player, BotaniaAPI.instance().getAccessoriesInventory(player), tool, item, doit);
        if (outStack.m_41619_()) {
            outStack = ItemExchangeRod.removeFromInventory(player, (Container)player.m_150109_(), tool, item, doit);
        }
        return outStack;
    }

    public static int getInventoryItemCount(Player player, ItemStack stack, Item item) {
        if (player.m_150110_().f_35937_) {
            return -1;
        }
        int baubleCount = ItemExchangeRod.getInventoryItemCount(player, BotaniaAPI.instance().getAccessoriesInventory(player), stack, item);
        if (baubleCount == -1) {
            return -1;
        }
        int count = ItemExchangeRod.getInventoryItemCount(player, (Container)player.m_150109_(), stack, item);
        if (count == -1) {
            return -1;
        }
        return count + baubleCount;
    }

    public static int getInventoryItemCount(Player player, Container inv, ItemStack stack, Item requested) {
        if (player.m_150110_().f_35937_) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            IBlockProvider prov;
            ItemStack invStack = inv.m_8020_(i);
            if (invStack.m_41619_()) continue;
            Item item = invStack.m_41720_();
            if (item == requested.m_5456_()) {
                count += invStack.m_41613_();
            }
            if ((prov = IXplatAbstractions.INSTANCE.findBlockProvider(invStack)) == null || !(requested instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)requested;
            int provCount = prov.getBlockCount(player, stack, blockItem.m_40614_());
            if (provCount == -1) {
                return -1;
            }
            count += provCount;
        }
        return count;
    }

    public void displayRemainderCounter(Player player, ItemStack stack) {
        if (!player.f_19853_.f_46443_) {
            Item item = this.getItemToPlace(stack);
            int count = ItemExchangeRod.getInventoryItemCount(player, stack, item);
            ItemsRemainingRenderHandler.send(player, new ItemStack((ItemLike)item), count);
        }
    }

    private void setItemToPlace(ItemStack stack, Item item) {
        ItemNBTHelper.setString(stack, TAG_REPLACEMENT_ITEM, Registry.f_122827_.m_7981_((Object)item).toString());
    }

    private Item getItemToPlace(ItemStack stack) {
        return (Item)Registry.f_122827_.m_7745_(ResourceLocation.m_135820_((String)ItemNBTHelper.getString(stack, TAG_REPLACEMENT_ITEM, "air")));
    }

    private void setHitPos(ItemStack stack, Vec3 vec) {
        ListTag list = new ListTag();
        list.add((Object)DoubleTag.m_128500_((double)Mth.m_14185_((double)vec.m_7096_())));
        list.add((Object)DoubleTag.m_128500_((double)Mth.m_14185_((double)vec.m_7098_())));
        list.add((Object)DoubleTag.m_128500_((double)Mth.m_14185_((double)vec.m_7094_())));
        stack.m_41784_().m_128365_(TAG_SWAP_HIT_VEC, (Tag)list);
    }

    private Vec3 getHitPos(ItemStack stack, BlockPos pos) {
        ListTag list = stack.m_41784_().m_128437_(TAG_SWAP_HIT_VEC, 6);
        return new Vec3((double)pos.m_123341_() + list.m_128772_(0), (double)pos.m_123342_() + list.m_128772_(1), (double)pos.m_123343_() + list.m_128772_(2));
    }

    private void setSwapTemplateDirection(ItemStack stack, Direction direction) {
        stack.m_41784_().m_128405_(TAG_SWAP_DIRECTION, direction.m_122411_());
    }

    private Direction getSwapTemplateDirection(ItemStack stack) {
        return Direction.m_122376_((int)stack.m_41784_().m_128451_(TAG_SWAP_DIRECTION));
    }

    private void setSwapClickDirection(ItemStack stack, Direction direction) {
        stack.m_41784_().m_128405_(TAG_SWAP_CLICKED_AXIS, direction.m_122411_());
    }

    private Direction getSwapClickDirection(ItemStack stack) {
        return Direction.m_122376_((int)stack.m_41784_().m_128451_(TAG_SWAP_CLICKED_AXIS));
    }

    private int getRange(ItemStack stack, Direction.Axis clickAxis, Direction.Axis rangeAxis) {
        if (stack.m_41784_().m_128471_(TAG_TEMPERANCE_STONE) && rangeAxis == clickAxis) {
            return 0;
        }
        return 3 + ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1) - 1;
    }

    private static void endSwapping(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_X);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_Y);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_Z);
        ItemNBTHelper.removeEntry(stack, TAG_TARGET_BLOCK_NAME);
        ItemNBTHelper.removeEntry(stack, TAG_SWAP_CLICKED_AXIS);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Item item = this.getItemToPlace(stack);
        MutableComponent cmp = super.m_7626_(stack).m_6881_();
        if (item != Items.f_41852_) {
            cmp.m_130946_(" (");
            Component sub = new ItemStack((ItemLike)item).m_41786_();
            cmp.m_7220_((Component)sub.m_6881_().m_130940_(ChatFormatting.GREEN));
            cmp.m_130946_(")");
        }
        return cmp;
    }

    private void setTarget(ItemStack stack, Block block) {
        ItemNBTHelper.setString(stack, TAG_TARGET_BLOCK_NAME, Registry.f_122824_.m_7981_((Object)block).toString());
    }

    public static Block getTargetState(ItemStack stack) {
        ResourceLocation id = new ResourceLocation(ItemNBTHelper.getString(stack, TAG_TARGET_BLOCK_NAME, "minecraft:air"));
        return (Block)Registry.f_122824_.m_7745_(id);
    }

    @Override
    public List<BlockPos> getWireframesToDraw(Player player, ItemStack stack) {
        ItemStack holding = player.m_21205_();
        if (holding != stack || !this.canExchange(stack)) {
            return ImmutableList.of();
        }
        HitResult pos = Minecraft.m_91087_().f_91077_;
        if (pos != null && pos.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos bPos = ((BlockHitResult)pos).m_82425_();
            Block target = Minecraft.m_91087_().f_91073_.m_8055_(bPos).m_60734_();
            if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
                bPos = new BlockPos(ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0));
                target = ItemExchangeRod.getTargetState(stack);
            }
            if (!player.f_19853_.m_46859_(bPos)) {
                Item item = this.getItemToPlace(stack);
                List<BlockPos> coordsList = this.getTargetPositions(player.f_19853_, stack, item, bPos, target, ((BlockHitResult)pos).m_82434_());
                coordsList.removeIf(arg_0 -> ((BlockPos)bPos).equals(arg_0));
                return coordsList;
            }
        }
        return ImmutableList.of();
    }
}

